

<?php $__env->startSection('title', 'Home'); ?>

<?php
$curPlyers = 0;
foreach($servers as $srv) {
    $curPlyers = $curPlyers + $srv->current_players;
}
?>

<?php $__env->startSection('content'); ?>
    <div class="hero-section">
        <div class="container">
            <div class="hero-content">
                <h1><?php echo e(config_value('site_name', 'Welcome!')); ?></h1>
                <p><?php echo e(config_value('tag_line', 'Your best place for gaming.')); ?></p>
                <div class="hero-buttons">
                </div>
            </div>
            <div class="server-stats">
                <div class="stat-item">
                    <span class="stat-value"><?php echo e($curPlyers); ?></span>
                    <span class="stat-label">Players Online</span>
                </div>
                <div class="stat-item">
                    <span class="stat-value"><?php echo e(\App\Models\User::count()); ?></span>
                    <span class="stat-label">Registered Users</span>
                </div>
                <div class="stat-item">
                    <span class="stat-value"><?php echo e(\App\Models\Server::count()); ?></span>
                    <span class="stat-label">Active Servers</span>
                </div>
            </div>
        </div>
    </div>

    <section class="features-section">
        <div class="container">
            <h2 class="section-title">Why Choose <?php echo e(config_value('site_name', 'Our Community')); ?>?</h2>
            <div class="features-grid">
                <?php for($i = 1; $i <= 4; $i++): ?>
                    <?php if(config_value("home_box_{$i}_enabled", false)): ?>
                        <div class="feature-card">
                            <div class="feature-icon">
                                <i class="fas fa-<?php echo e(config_value("home_box_{$i}_fa_icon", 'star')); ?> fa-2x"></i>
                            </div>
                            <h3><?php echo e(config_value("home_box_{$i}_title", "Feature Title {$i}")); ?></h3>
                            <p><?php echo e(config_value("home_box_{$i}_text", "Feature description for box {$i}.")); ?></p>
                        </div>
                    <?php endif; ?>
                <?php endfor; ?>
            </div>
        </div>
    </section>

    <?php
        $gamemodes = [
            'darkrp' => 'DarkRP',
            'deathrun' => 'Deathrun',
            'ttt' => 'Trouble in Terrorist Town',
            'scprp' => 'SCP RP',
            'murder' => 'Murder',
            'prophunt' => 'Prop Hunt',
        ];

        function formatGamemode($gamemodeString, $gamemodes) {
            if (preg_match('/gm:([^\s]+)/', $gamemodeString, $matches)) {
                $gamemodeKey = strtolower($matches[1]);
                return $gamemodes[$gamemodeKey] ?? ucfirst($gamemodeKey);
            }
            return $gamemodeString;
        }
    ?>

    <?php if(config_value('servers_enabled', false)): ?>
        <section class="servers-section" id="servers">
            <div class="container">
                <h2 class="section-title">Our Servers</h2>
                <div class="servers-grid">
                    <?php $__empty_1 = true; $__currentLoopData = $servers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="server-card">
                            <div class="server-header">
                                <h3><?php echo e($server->name); ?></h3>
                                <span class="server-status <?php echo e($server->status); ?>"><?php echo e(ucfirst($server->status)); ?></span>
                            </div>
                            <div class="server-info">
                                <div class="info-item">
                                    <span class="info-label">Players:</span>
                                    <span class="info-value"><?php echo e($server->current_players); ?>/<?php echo e($server->max_players); ?></span>
                                </div>
                                <div class="info-item">
                                    <span class="info-label">Map:</span>
                                    <span class="info-value"><?php echo e($server->current_map); ?></span>
                                </div>
                                <div class="info-item">
                                    <span class="info-label">Gamemode:</span>
                                    <span class="info-value"><?php echo e(formatGamemode($server->gamemode, $gamemodes)); ?></span>
                                </div>
                            </div>
                            <a href="<?php echo e($server->connect_url); ?>" class="btn btn-primary btn-block">Connect Now</a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="no-servers">
                            <p>No servers are currently available.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    <?php endif; ?>


    <?php if(config_value('toggle_news') === true && config_value('news_enabled') === true && count($latestNews) > 0): ?>
        <section class="news-section">
            <div class="container">
                <h2 class="section-title">Latest News</h2>
                <div class="news-grid">
                    <?php $__currentLoopData = $latestNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="news-card">
                        <div class="news-image">
                            <img src="<?php echo e(asset('storage/' . $news->image)); ?>" alt="News 1">
                        </div>
                        <div class="news-content">
                            <span class="news-date"><?php echo e($news->created_at->format('F d, Y')); ?></span>
                            <h3><?php echo e($news->title); ?></h3>
                            <p><?php echo e($news->short_description); ?></p>
                            <a href="<?php echo e(route('news.show', $news->slug)); ?>" class="read-more">Read More</a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="view-all-news">
                    <a href="<?php echo e(route('news.index')); ?>" class="btn btn-secondary">View All News</a>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if(config_value('home_call_to_action_enabled', false)): ?>
        <section class="cta-section">
            <div class="container">
                <div class="cta-content">
                    <h2><?php echo e(config_value('home_call_to_action_title', 'Join Us Today!')); ?></h2>
                    <p><?php echo e(config_value('home_call_to_action_text', 'Start your journey now and join our awesome community!')); ?></p>
                </div>
            </div>
        </section>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/home.blade.php ENDPATH**/ ?>